<?php include PATH_VIEW.'/layout/header.tpl'; ?>

<div id="ajaxArea">
	<div class="container bg-body-tertiary p-3">
		
		<div class="row">

			<div class="col-md-8">
				
				<section id="column1" class="mb-4">
					<section id="breadcrumb" class="border-bottom mb-4">
						<?php include PATH_VIEW.'/layout/breadcrumb.tpl' ?>
					</section>
					
					<article itemscope itemtype="https://schema.org/NewsArticle">
						<h1 itemprop="headline" class="title-post"><?php echo $item->title; ?></h1>
						
						<p itemprop="description" class="mb-0"><?php echo $item->description; ?>...</p>

						<div class="d-flex justify-content-between align-items-center flex-sm-row  flex-column mb-3">
							<div class="mt-3">
								<span itemprop="datePublished" content="<?php echo $item->date_post ?>"><?php echo FormatDate($setting->format_date. ' ' .$setting->format_time, $item->date_post); ?><span>
							</div>
							<div class="mt-3" id="shareBS" data-url="<?php echo $og_url; ?>" data-title="<?php echo $og_title; ?>"></div>
						</div>

						<figure class="mb-3">
							<img itemprop="image" loading="lazy" src="<?php echo $og_image; ?>" class="img-fluid mx-auto d-block rounded col-12" alt="<?php echo $item->title; ?>">
							<figcaption class="mt-1 text-muted"><small><?php echo $item->title . ' ' . $_LANG['photo_reproduction']; ?></small></figcaption>
						</figure>
					
						<p><?php echo $item->contents; ?></p>
						
						<div class="pt-3">
							<p class="h6"><?php echo $_LANG['reproduction-source']; ?>:</p>
							<a  href="<?php echo $item->link; ?>" target="_blank"><?php echo $item->link; ?></a>
						</div>

					</article>
				</section>
				
			</div>

			<div class="col-md-4">
				<aside>
					<section id="column2" class="row">
						<?php 
							// widgets column 2
							$widgetPos = 4;
							include PATH_VIEW.'/layout/widget.tpl';
						?>
					</section>
				</aside>
			</div>


		</div>
		
	</div>
</div>

<?php include PATH_VIEW.'/layout/footer.tpl'; ?>